clear all 
close all

% this script accompanies Walcott et al., 2024 (preprint) and runs a 
% forward model for calculating cosmogenic 10Be, 26Al, and 14C
% concentrations accumulated over Quaternary glacial cycles, and includes
% subglacial and subaerial erosion. 

% Allie Balter-Kennedy - July 2024

%% load sample data

[d loc] = get_ingle_data();

%% calculate production rate info for each sample

[p consts] = calc_p(loc, d);

%% define model space

% choose values
oxy = [3.9:0.02:4.0]; % threshold on LR04 stack [permil] 
egl = [0 logspace(-12, -6, 7) logspace(-5, log10(2.5e-1), 50)]; % subglacial erosion rate. passed from here in [mm/yr].
esa = egl; % subaerial erosion rate. passed from here in [mm/yr].

zmax = 6; % greater than the deepest sample depth in cm for definition of depths over which cosmo calc

mp.z_gcm = [0 logspace(-1, log10(zmax.*2.65), 10)]; % could decide to move this around?
fix = 30; % time after which exposure history defined by local history [kyr]

%% run model

% need to "step" into each d18O, then "step" into each erosion scenario.
% then run model for each sample in each erosion sample. store somehow. 


for a = 1:length(oxy) % cycle through exposure histories
tic
    mp.hp = hist_param(oxy(a), fix);

    for b = 1:length(egl) % cycle through subglacial erosion rates
        for c = 1:length(esa) % cycle through subaerial erosion rates
            
            % mp.hp = hp;
            mp.ep = erode_param(egl(b), esa(c), mp.hp);
            
            for i = 1:length(d)      
                
                 result = quaterode_forward_model(mp, d{i}, p{i}, consts, 1);
                
                 model.N10(b, c, a, i) = result.N10p;
                 model.N26(b, c, a, i) = result.N26p;
                 model.N14(b, c, a, i) = result.N14p;
                 model.miss10(b, c, a, i) = result.miss10;
                 model.miss26(b, c, a, i) = result.miss26;
                 model.x2(b, c, a, i) = result.x2;
                 
            end
        end
    end
toc
a
end


model.oxy = oxy;
model.egl = egl;
model.esa = esa;

%% Save output

% add units

model.units(:, 1) = {'d18O threshold'; 'subglacial erosion'; 'subaerial erosion'};
model.units(:, 2) = {'permil'; 'mm/yr'; 'mm/yr'};

% uncomment to save output

% % FormatFile = 'outputs/quaterode_ingle_%0.1f-%0.1fpermil_SGE_%0.01f-%0.01f_SAE_%0.01f-%0.01f_Feb9run.mat';
% % filename = sprintf(FormatFile, round(oxy(1),2), round(oxy(end),2), round(egl(1), 4),round(egl(end), 4), round(esa(1), 4), round(esa, 4));
% 
% filename = 'outputs/Mar24Run_2.7Myr_3.90-4.0_variablegrid.mat';
% save(filename, 'model', 'oxy', 'esa', 'egl', 'd', 'p', 'consts', 'loc');
